import java.awt.*;

/** A square of the Board Game */
public class Square extends Canvas { 
   static public final int EMPTY= 0; // Constants used to indicate
   static public final int WHITE= 1; // what is on a square.
   static public final int BLACK= 2; // Meaning: obvious

   Rectangle b;     // Containing rectangle of this square
   int col;			// column number of this square on board
   int row;			// row number of this square on board

   // EMPTY: square is empty; WHITE means white piece is on
   // square; BLACK means black piece is on square
	  private int fill= EMPTY;

   /** Constructor: An initially empty square that belongs in
       column c, row r of the board */
   public Square(int c, int r) {
      super();
      col= c;
      row= r;
      setBackground(Color.green);
      setSize(42,42);
      b= getBounds();
      repaint();
   }

   /** Paint the square depending on field fill, using Graphics g */
   public void paint (Graphics g) {
      Color save= g.getColor(); // Save the color, to be reset at end
      g.setColor(Color.black);
      g.drawRect(b.x, b.y, b.width-1, b.height-1);
      if (fill == WHITE) 
         g.setColor(Color.white); 
      if (fill != EMPTY) 
         g.fillOval(b.x+b.width/4, b.y+b.width/4,b.width/2, b.height/2); 
      g.setColor(save);
   }
  
  /** Yield the contents of the square --EMPTY, WHITE, or BLACK */
     public int contents() {
        return fill;
	 } 

   /** Place piece p (either WHITE or BLACK) in this square (no action if
       square aleady filled) */
   public void placePiece(int p) {
      if (fill != EMPTY) return;
      fill= p;
      repaint();
      return;
   }

   /** Pick up the piece (no action if square is empty) */
   public void pickUpPiece() {
      if (fill == EMPTY) return;
      fill= EMPTY;
      repaint();
      return;
   }
}
